/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.pspIdStorageCertificate;
import jpcsp.hardware.Model;
import jpcsp.hardware.Wlan;
import jpcsp.memory.mmio.umd.MMIOHandlerUmd;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceIdStorage
extends HLEModule {
    public static Logger log = Modules.getLogger("sceIdStorage");
    public static final int[] idStorageKeys = new int[]{65535, 65535, 4, 5, 6, 7, 8, 16, 17, 65, 67, 68, 69, 70, 71, 84, 256, 257, 258, 259, 260, 261, 262, 288, 289, 290, 291, 292, 293, 294, 321};

    private static void writeStringType(TPointer buffer, int offset, String s) {
        buffer.setValue8(offset++, (byte)((s.length() + 1) * 2));
        buffer.setValue8(offset++, (byte)3);
        for (int i = 0; i < s.length(); ++i) {
            buffer.setValue8(offset++, (byte)s.charAt(i));
            buffer.setValue8(offset++, (byte)0);
        }
        buffer.setValue8(offset++, (byte)0);
        buffer.setValue8(offset++, (byte)0);
    }

    private void storeCertificate(TPointer buffer, int offset, int[] hash, int[] signature, int[] publicKey, int[] decryptedPrivateKey, int[] unknown) {
        this.storeCertificate(buffer, offset, Utilities.intArrayToByteArray(hash), Utilities.intArrayToByteArray(signature), Utilities.intArrayToByteArray(publicKey), Utilities.intArrayToByteArray(decryptedPrivateKey), Utilities.intArrayToByteArray(unknown));
    }

    private void storeCertificate(TPointer buffer, int offset, byte[] hash, byte[] signature, byte[] publicKey, byte[] decryptedPrivateKey, byte[] unknown) {
        pspIdStorageCertificate certificate = new pspIdStorageCertificate();
        certificate.setHash(hash);
        certificate.setSignature(signature);
        certificate.setPublicKey(publicKey);
        certificate.encryptPrivateKey(decryptedPrivateKey);
        certificate.setUnknown(unknown);
        certificate.write(buffer, offset);
    }

    public int hleIdStorageReadLeaf(int key, TPointer buffer) {
        buffer.clear(512);
        switch (key) {
            case 4: {
                buffer.setValue32(0, 1114798446);
                buffer.setUnsignedValue8(24, 148);
                break;
            }
            case 5: {
                buffer.setValue32(0, 1131178855);
                buffer.setUnsignedValue8(16, 10);
                break;
            }
            case 6: {
                buffer.setValue32(0, 1296327794);
                break;
            }
            case 7: {
                buffer.setValue32(0, 1095786820);
                break;
            }
            case 8: {
                buffer.setValue32(0, 1279476848);
                buffer.setUnalignedValue16(16, 10);
                buffer.setUnalignedValue16(18, 25);
                buffer.setUnalignedValue16(20, 16);
                buffer.setUnalignedValue16(22, 14);
                buffer.setUnalignedValue16(24, 11);
                buffer.setUnalignedValue16(26, 8);
                buffer.setUnalignedValue16(28, 114);
                break;
            }
            case 65: {
                int offset = 0;
                buffer.setValue32(offset, 1356);
                offset += 4;
                sceIdStorage.writeStringType(buffer, 4, "Sony");
                int[] types = new int[]{456, 457, 458, 459, 460};
                String[] typeNames = new String[]{"PSP Type A", "PSP Type B", "PSP Type C", "PSP Type D", "PSP Type E"};
                buffer.setValue32(offset += 64, types.length);
                offset += 4;
                for (int i = 0; i < types.length; ++i) {
                    buffer.setValue32(offset, types[i]);
                    sceIdStorage.writeStringType(buffer, offset += 4, typeNames[i]);
                    offset += 64;
                }
                break;
            }
            case 68: {
                buffer.setArray(0, Wlan.getMacAddress());
                break;
            }
            case 69: {
                int wlanFirmwareVersion = 0;
                if (Model.getGeneration() > 1) {
                    wlanFirmwareVersion = 1;
                }
                buffer.setUnsignedValue16(0, 2 | wlanFirmwareVersion << 12);
                buffer.setUnsignedValue8(2, 1);
                buffer.setUnsignedValue8(3, 0);
                buffer.setUnsignedValue8(4, 0);
                break;
            }
            case 256: {
                int certificateOffset = 56;
                int certificateLength = 184;
                buffer.clear(certificateOffset, certificateLength);
                int unknownValue = Modules.sceChkregModule.getValueReturnedBy6894A027();
                buffer.setValue32(certificateOffset + 0, Utilities.endianSwap32(1));
                buffer.setUnsignedValue16(certificateOffset + 4, Utilities.endianSwap16(5));
                buffer.setUnsignedValue16(certificateOffset + 6, Utilities.endianSwap16(1));
                buffer.setUnsignedValue8(certificateOffset + 8, 0x8C | unknownValue >> 6 & 3);
                buffer.setUnsignedValue8(certificateOffset + 9, unknownValue << 2 & 0xFC);
                int[] hash = new int[]{0, 0, 0, 1, 0, 5, 0, 1, 8, 41, 61, 51, 122, 230, 197, 125, 59, 91, 221, 128, 175, 191, 78, 94, 217, 155, 177, 152, 40, 182, 159, 53, 242, 56, 58, 255, 5, 184, 70, 133, 249, 197, 94, 55, 132, 226, 128, 121, 248, 97, 146, 74, 86, 7, 174, 104};
                int[] signature = new int[]{242, 49, 111, 118, 75, 148, 149, 188, 208, 81, 3, 107, 123, 172, 78, 177, 57, 211, 213, 201, 214, 15, 22, 86, 217, 249, 49, 50, 118, 138, 213, 207, 228, 48, 136, 193, 147, 189, 247, 149};
                int[] publicKey = new int[]{6, 72, 95, 208, 41, 133, 59, 85, 47, 126, 253, 214, 122, 45, 231, 161, 164, 226, 85, 55, 178, 69, 157, 135, 134, 66, 109, 91, 39, 239, 165, 169, 49, 28, 184, 171, 171, 250, 14, 206};
                int[] decryptedPrivateKey = new int[]{73, 92, 229, 49, 88, 213, 1, 50, 37, 23, 195, 22, 117, 46, 118, 40, 234, 5, 169, 232, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                int[] unknown = new int[]{104, 40, 28, 142, 163, 209, 125, 5, 34, 198, 122, 66, 191, 126, 157, 205};
                this.storeCertificate(buffer, 240, hash, signature, publicKey, decryptedPrivateKey, unknown);
                break;
            }
            case 258: {
                buffer.setValue32(140, 96);
                for (int i = 0; i < MMIOHandlerUmd.regionCodes.length; ++i) {
                    buffer.setValue32(176 + i * 4, MMIOHandlerUmd.regionCodes[i]);
                }
                break;
            }
            case 321: {
                return -2147483611;
            }
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1424843488, version=150)
    public int sceIdStorageInit() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=752926313, version=150)
    public int sceIdStorageEnd() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-143301194, version=150)
    public int sceIdStorageSuspend() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-28240067, version=150)
    public int sceIdStorageResume() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-343734477, version=150)
    public int sceIdStorageGetLeafSize() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-17153854, version=150)
    public int sceIdStorageIsFormatted() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=761476744, version=150)
    public int sceIdStorageIsReadOnly() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1190749267, version=150)
    public int sceIdStorageIsDirty() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1786738213, version=150)
    public int sceIdStorageFormat() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-188959762, version=150)
    public int sceIdStorageUnformat() {
        return 0;
    }

    @HLEFunction(nid=-352271095, version=150)
    public int sceIdStorageReadLeaf(int key, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=512, usage=BufferInfo.Usage.out) TPointer buffer) {
        return this.hleIdStorageReadLeaf(key, buffer);
    }

    @HLEUnimplemented
    @HLEFunction(nid=530895157, version=150)
    public int sceIdStorageWriteLeaf() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=144994726, version=150)
    public int sceIdStorageCreateLeaf() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=748137270, version=150)
    public int sceIdStorageDeleteLeaf() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1716728975, version=150)
    public int sceIdStorage_driver_99ACCB71() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=931347640, version=150)
    public int sceIdStorage_driver_37833CB8() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=836799227, version=150)
    public int sceIdStorageEnumId() {
        return 0;
    }

    @HLEFunction(nid=1876976337, version=150)
    public int sceIdStorageLookup(int key, int offset, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.out) TPointer buffer, int length) {
        TPointer leafBuffer = Utilities.allocatePointer(512);
        int result = this.hleIdStorageReadLeaf(key, leafBuffer);
        if (result < 0) {
            return result;
        }
        buffer.memcpy(leafBuffer.add(offset), length);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1748675600, version=150)
    public int sceIdStorageUpdate() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=986916131, version=150)
    public int sceIdStorageFlush() {
        return 0;
    }
}

